//
//  CheckListController.m
//  Nav
//
//  Created by Robert Górczyński on 11-07-05.
//

#import "CheckListController.h"


@implementation CheckListController
@synthesize list; 
@synthesize lastIndexPath; 

- (void)viewDidLoad { 
	
    NSArray *array = [[NSArray alloc] initWithObjects:@"Siekane mięso", 
					  @"Szaszłyk", @"Pudding", @"Zakąski", 
					  @"Landrynki", @"Jajka i szynka", @"Zielona pożywka", 
					  @"Łosoś", @"Chleb pszenny", @"Chleb razowy", @"Budyń", nil]; 
    self.list = array; 
    [array release]; 
	
    [super viewDidLoad]; 
} 

- (void)viewDidUnload { 
    self.list = nil; 
    self.lastIndexPath = nil; 
    [super viewDidUnload]; 
} 

- (void)dealloc { 
    [list release]; 
    [lastIndexPath release]; 
    [super dealloc]; 
} 

#pragma mark - 
#pragma mark Metody źródła danych tabeli
- (NSInteger)tableView:(UITableView *)tableView 
 numberOfRowsInSection:(NSInteger)section {
    return [list count]; 
} 

- (UITableViewCell *)tableView:(UITableView *)tableView 
		 cellForRowAtIndexPath:(NSIndexPath *)indexPath { 
    static NSString *CheckMarkCellIdentifier = @"CheckMarkCellIdentifier"; 
	
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier: 
							 CheckMarkCellIdentifier]; 
    if (cell == nil) { 
        cell = [[[UITableViewCell alloc] 
				 initWithStyle:UITableViewCellStyleDefault 
				 reuseIdentifier:CheckMarkCellIdentifier] autorelease]; 
    } 
    NSUInteger row = [indexPath row]; 
    NSUInteger oldRow = [lastIndexPath row]; 
    cell.textLabel.text = [list objectAtIndex:row]; 
    cell.accessoryType = (row == oldRow && lastIndexPath != nil) ? 
	UITableViewCellAccessoryCheckmark : UITableViewCellAccessoryNone; 
	
    return cell; 
} 

#pragma mark - 
#pragma mark Metody delegata tabeli
- (void)tableView:(UITableView *)tableView 
didSelectRowAtIndexPath:(NSIndexPath *)indexPath { 
	int newRow = [indexPath row]; 
    int oldRow = (lastIndexPath != nil) ? [lastIndexPath row] : -1; 
	
    if (newRow != oldRow) { 
        UITableViewCell *newCell = [tableView cellForRowAtIndexPath: 
                                    indexPath]; 
        newCell.accessoryType = UITableViewCellAccessoryCheckmark; 
		
        UITableViewCell *oldCell = [tableView cellForRowAtIndexPath: 
                                    lastIndexPath]; 
        oldCell.accessoryType = UITableViewCellAccessoryNone; 
        lastIndexPath = indexPath; 
    } 
    [tableView deselectRowAtIndexPath:indexPath animated:YES]; 
} 

@end
